"""Employee data model using Pydantic for validation."""

from datetime import date
from typing import Optional
from pydantic import BaseModel, EmailStr, Field


class Employee(BaseModel):
    """Represents an employee in the CA office."""

    id: Optional[int] = Field(default=None, description="Auto‑increment primary key")
    emp_code: str = Field(..., description="Unique employee code")
    full_name: str
    designation: Optional[str] = None
    email: Optional[EmailStr] = None
    phone: Optional[str] = None
    date_joined: date
    is_active: bool = Field(default=True)

    class Config:
        orm_mode = True